/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.logs_analyser.crash_reasons.log;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.CorruptedJarFinderGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;

public class CorruptedModJar
extends KnownCrashReason {
    public CorruptedModJar() {
        super(new HashSet<LogType>(){
            {
                this.add(LogType.LOG);
                this.add(LogType.CRASH_REPORT);
                this.add(LogType.LAUNCHER_LOG);
            }
        }, LanguageProvider.get((String)"warnings.corrupted_mod_jar"), new String[0]);
        this.autoFixButtons.put(LanguageProvider.get((String)"gui.analysis.find_corrupted_mod_jars"), dialog -> CorruptedJarFinderGUI.showDialog((JFrame)dialog.getOwner()));
    }

    @Override
    public boolean matches(Log log) {
        if (CrashAssistantApp.gameLaunchedSuccessfully) {
            return false;
        }
        if (!PlatformHelp.isForgeBased()) {
            return false;
        }
        List<String> lines = log.getReader().getAllLinesList();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.contains("zip") || !line.contains("zip END header not found") && !line.contains("zip file is empty")) continue;
            List<String> linesToSearch = lines.subList(Math.max(0, i - 1), Math.min(lines.size(), i + 2));
            boolean found = false;
            for (String lineToSearch : linesToSearch) {
                if (lineToSearch.contains("UnionFileSystem$UncheckedIOException")) {
                    found = true;
                }
                if (lineToSearch.contains("Error during early discovery")) {
                    found = true;
                }
                if (lineToSearch.contains("File ") && lineToSearch.contains(" is not a jar file")) {
                    found = true;
                }
                if (!lineToSearch.contains("Failed to create secure jar for")) continue;
                found = true;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }
}

